/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os;

import com.ibm.jsio.SioDevice;
import com.ibm.jsio.SioIrp;
import com.ibm.jsio.SioSlot;
import com.ibm.jsio.event.DefaultSioDeviceEventHelper;
import com.ibm.jsio.event.SioDeviceEventHelper;
import com.ibm.jsio.event.SioDeviceListener;
import com.ibm.jsio.os.SioIrpImp;
import com.ibm.jsio.os.SioIrpRecyclable;

public abstract class AbstractSioDevice
implements SioDevice {
    private SioSlot sioSlot = null;
    private byte portNumber = 0;
    private byte deviceNumber = 0;
    private boolean attached = false;
    private boolean isOpen = false;
    private SioDeviceEventHelper eventHelper = new DefaultSioDeviceEventHelper();

    protected AbstractSioDevice(SioSlot slot, byte port, byte device) {
        if (slot == null) {
            throw new IllegalArgumentException("SioSlot object must not be null");
        }
        this.sioSlot = slot;
        this.portNumber = port;
        this.deviceNumber = device;
    }

    public void addSioDeviceListener(SioDeviceListener listener) {
        this.eventHelper.addSioDeviceListener(listener);
    }

    public void removeSioDeviceListener(SioDeviceListener listener) {
        this.eventHelper.removeSioDeviceListener(listener);
    }

    public SioIrp createSioIrp(byte[] data, boolean recyclable) {
        if (recyclable) {
            return SioIrpRecyclable.createSioIrpRecyclable(data);
        }
        return new SioIrpImp(data);
    }

    public SioIrp createSioIrp(byte[] data, int o, int l, boolean recyclable) {
        if (recyclable) {
            return SioIrpRecyclable.createSioIrpRecyclable(data, o, l);
        }
        return new SioIrpImp(data, o, l);
    }

    public byte getDeviceNumber() {
        return this.deviceNumber;
    }

    public byte getPortNumber() {
        return this.portNumber;
    }

    public byte getSioSlotNumber() {
        return this.sioSlot.getSioSlotNumber();
    }

    public SioSlot getSioSlot() {
        return this.sioSlot;
    }

    public boolean isDeviceAttached() {
        return this.attached;
    }

    public void setDeviceAttached(boolean b) {
        this.attached = b;
    }

    public boolean isOpen() {
        return this.attached;
    }

    public void setOpen(boolean b) {
        this.isOpen = b;
    }

    protected SioDeviceEventHelper getEventHelper() {
        return this.eventHelper;
    }
}

