/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os;

import com.ibm.jsio.SioException;
import com.ibm.jsio.SioIrp;

public class SioIrpImp
implements SioIrp {
    private byte[] data = new byte[0];
    private boolean complete = false;
    private int offset = 0;
    private int length = 0;
    private int actualLength = 0;
    private SioException sioException = null;
    private Object waitLock = new Object();

    public SioIrpImp() {
    }

    public SioIrpImp(byte[] d) {
        this.setData(d);
    }

    public SioIrpImp(byte[] d, int off, int len) {
        this.setData(d, off, len);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getActualLength() {
        return this.actualLength;
    }

    public void setData(byte[] d) throws IllegalArgumentException {
        this.setData(d, 0, d.length);
    }

    public void setData(byte[] d, int o, int l) throws IllegalArgumentException {
        if (null == d) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        this.data = d;
        this.setOffset(o);
        this.setLength(l);
    }

    public void setOffset(int o) throws IllegalArgumentException {
        if (0 > o) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        this.offset = o;
    }

    public void setLength(int l) throws IllegalArgumentException {
        if (0 > l) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        this.length = l;
    }

    public void setActualLength(int l) throws IllegalArgumentException {
        if (0 > l) {
            throw new IllegalArgumentException("Actual length cannot be negative");
        }
        this.actualLength = l;
    }

    public boolean isSioException() {
        return null != this.getSioException();
    }

    public SioException getSioException() {
        return this.sioException;
    }

    public void setSioException(SioException exception) {
        this.sioException = exception;
    }

    public boolean isComplete() {
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComplete(boolean b) {
        this.complete = b;
        if (b) {
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilComplete() {
        if (!this.isComplete()) {
            Object object = this.waitLock;
            synchronized (object) {
                while (!this.isComplete()) {
                    try {
                        this.waitLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilComplete(long timeout) {
        if (0L >= timeout) {
            this.waitUntilComplete();
            return;
        }
        long startTime = System.currentTimeMillis();
        if (!this.isComplete()) {
            Object object = this.waitLock;
            synchronized (object) {
                if (!this.isComplete() && System.currentTimeMillis() - startTime < timeout) {
                    try {
                        this.waitLock.wait(timeout);
                    }
                    catch (InterruptedException iE) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

