/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioException;
import com.ibm.jsio.os.sockets.SioImpUtil;
import com.ibm.jsio.os.sockets.SioProtocol;
import com.ibm.jsio.os.sockets.SioState;

abstract class SioAbstractCommOnGoingState
extends SioState {
    static /* synthetic */ Class class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState;

    public SioAbstractCommOnGoingState(SioProtocol protocol) {
        super(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void messageReceived(byte[] msg) {
        this.lastMsg = msg;
        if (SioImpUtil.is485Message(this.lastMsg)) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "{Dev: " + Integer.toHexString(this.protocol.getDeviceNumber()) + "} " + SioImpUtil.getClassName(this) + "Message Received. Type: " + SioProtocol.getTypeOfMessage(this.lastMsg));
            }
            try {
                this.protocol.sendAck(this.lastMsg);
            }
            catch (SioException e) {
                this.processException(e);
            }
            switch (SioProtocol.getTypeOfMessage(this.lastMsg)) {
                case 'N': {
                    this.doNewMessageReceived();
                    break;
                }
                case 'B': {
                    this.doLastAckLost();
                    break;
                }
                case 'Q': {
                    this.doCommandRejectInProgress();
                    break;
                }
                case 'R': {
                    this.doPowerOnResetInProgress();
                    break;
                }
                case 'G': 
                case 'P': {
                    this.doCommunicationLost();
                    break;
                }
                case 'A': 
                case 'L': {
                    break;
                }
                case 'C': 
                case 'S': {
                    break;
                }
                default: {
                    this.doDefault();
                    break;
                }
            }
        } else if (SioImpUtil.isControlMessage(this.lastMsg)) {
            this.protocol.setControlMessage(this.lastMsg);
            this.processControlMessage();
        } else if (SioImpUtil.isAckMessage(this.lastMsg)) {
            Object object;
            if (SioImpUtil.checkValue(this.lastMsg, "<ack>FAIL")) {
                object = this.protocol.getLockSyncAck();
                synchronized (object) {
                    this.protocol.setAckFailed(true);
                    this.protocol.setSyncArrived(true);
                    this.protocol.getLockSyncAck().notify();
                }
            } else {
                this.protocol.setAckFailed(false);
            }
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Unlocking Async Calls");
            }
            object = this.protocol.getLockAsyncAck();
            synchronized (object) {
                this.protocol.setAsyncArrived(true);
                this.protocol.getLockAsyncAck().notify();
            }
        }
    }

    protected void doDefault() {
        this.protocol.setCurrentState(class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState == null ? (class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState = SioAbstractCommOnGoingState.class$("com.ibm.jsio.os.sockets.SioWaitResetCompleteState")) : class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState);
        this.protocol.fireErrorEvent(new SioException("Internal Error"), 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommunicationLost() {
        this.protocol.setCurrentState(class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState == null ? (class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState = SioAbstractCommOnGoingState.class$("com.ibm.jsio.os.sockets.SioWaitResetCompleteState")) : class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState);
        try {
            this.protocol.doIrpSubmit(null, 'D', 0);
            this.protocol.doIrpSubmit(null, 'R', 0);
        }
        catch (SioException e) {
            this.processException(e);
        }
        Object object = this.protocol.getLockSyncAck();
        synchronized (object) {
            this.protocol.setCommunicationLost(true);
            this.protocol.setSyncArrived(true);
            this.protocol.getLockSyncAck().notify();
        }
        if (this.protocol.isDeviceAttached()) {
            this.protocol.setDeviceAttached(false);
            this.protocol.fireErrorEvent(new SioException("Communication with the device is lost"), 14);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSequenceResetInProgress() {
        try {
            this.protocol.doIrpSubmit(null, 'D', 0);
            this.protocol.doIrpSubmit(null, 'R', 0);
            this.protocol.setCurrentState(class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState == null ? (class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState = SioAbstractCommOnGoingState.class$("com.ibm.jsio.os.sockets.SioWaitResetCompleteState")) : class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState);
            Object object = this.protocol.getLockSyncAck();
            synchronized (object) {
                this.protocol.setCommunicationError(true);
                this.protocol.setSyncArrived(true);
                this.protocol.getLockSyncAck().notify();
            }
            this.protocol.fireErrorEvent(new SioException("Device Communication Error"), 13);
            this.doAsyncLost(false);
        }
        catch (SioException e) {
            this.processException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommandRejectInProgress() {
        try {
            this.protocol.doIrpSubmit(null, 'D', 0);
            this.protocol.doIrpSubmit(null, 'R', 0);
            Object object = this.protocol.getLockSyncAck();
            synchronized (object) {
                this.protocol.setCommunicationError(true);
                this.protocol.setSyncArrived(true);
                this.protocol.getLockSyncAck().notify();
            }
            this.protocol.fireErrorEvent(new SioException("Device Communication Error"), 13);
            this.doAsyncLost(true);
        }
        catch (SioException e) {
            this.processException(e);
        }
    }

    protected void doLastAckLost() {
        try {
            this.protocol.doIrpSubmit(null, 'R', 0);
        }
        catch (SioException e) {
            this.processException(e);
        }
    }

    protected void doNewMessageReceived() {
        if (this.tracer.isOn()) {
            this.tracer.println(2, "{Dev: " + Integer.toHexString(this.protocol.getDeviceNumber() & 0xFF) + "} " + "Data Received -> " + SioImpUtil.formatData(this.protocol.extractData(this.lastMsg)));
        }
        if (SioImpUtil.isTruncatedMsg(this.lastMsg)) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Firing ERROR_COMMUNICATION_ERROR. Truncated packet received.");
            }
            this.protocol.fireErrorEvent(new SioException("The device has sent more data than the comm protocol can accept."), 13);
        } else {
            this.protocol.fireDataEvent(null, this.protocol.extractData(this.lastMsg));
        }
    }

    protected void doError() {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> doError()");
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.protocol.getDeviceNumber()) + "} " + SioImpUtil.getClassName(this) + " " + "Internal Error");
        }
        this.protocol.setCurrentState(class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState == null ? (class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState = SioAbstractCommOnGoingState.class$("com.ibm.jsio.os.sockets.SioWaitResetCompleteState")) : class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState);
        this.protocol.fireErrorEvent(new SioException("Internal Error"), 12);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- doError()");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

