/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioException;
import com.ibm.jsio.SioIrp;
import com.ibm.jsio.os.sockets.SioAbstractCommOnGoingState;
import com.ibm.jsio.os.sockets.SioImpUtil;
import com.ibm.jsio.os.sockets.SioProtocol;
import java.util.Iterator;

class SioCommOnGoingState
extends SioAbstractCommOnGoingState {
    protected Integer msgId = null;

    public SioCommOnGoingState(SioProtocol protocol) {
        super(protocol);
    }

    public void asyncSubmit(SioIrp irp) throws SioException {
        this.protocol.doIrpAsyncSubmit(irp, 'W', this.protocol.getFlags());
    }

    public void syncSubmit(SioIrp irp) throws SioException {
        this.protocol.doIrpSyncSubmit(irp, 'W', this.protocol.getFlags());
    }

    public synchronized void messageReceived(byte[] msg) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> messageReceived()");
        }
        super.messageReceived(msg);
        this.msgId = SioImpUtil.getMsgId(this.lastMsg);
        if (SioImpUtil.is485Message(this.lastMsg)) {
            switch (SioProtocol.getTypeOfMessage(this.lastMsg)) {
                case 'L': {
                    if (this.protocol.getSyncMsgId() == this.msgId.intValue()) {
                        this.doSyncMessageLost();
                        break;
                    }
                    if (!this.protocol.getUnAckedIrps().containsKey(this.msgId)) break;
                    this.doLastAsyncMessageLost();
                    break;
                }
                case 'A': {
                    if (this.protocol.getSyncMsgId() == this.msgId.intValue()) {
                        this.doSyncMessageAcked();
                        break;
                    }
                    if (!this.protocol.getUnAckedIrps().containsKey(this.msgId)) break;
                    this.doLastAsyncMessageAcked();
                }
            }
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- messageReceived()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSyncMessageAcked() {
        this.protocol.setSyncRetrans(0);
        this.protocol.setLastSyncIrp(null);
        Object object = this.protocol.getLockSyncAck();
        synchronized (object) {
            this.protocol.setSyncArrived(true);
            this.protocol.getLockSyncAck().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSyncMessageLost() {
        this.protocol.setSyncRetrans(this.protocol.getSyncRetrans() + 1);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "Retrying " + this.protocol.getSyncRetrans());
        }
        if (this.protocol.getSyncRetrans() <= this.protocol.getMaxAttempts()) {
            try {
                this.protocol.doIrpSubmit(null, 'R', 0);
            }
            catch (SioException e) {
                this.processException(e);
            }
        } else {
            try {
                this.protocol.doIrpSubmit(null, 'D', 0);
                this.protocol.doIrpSubmit(null, 'R', 0);
            }
            catch (SioException e) {
                this.processException(e);
            }
            Object object = this.protocol.getLockSyncAck();
            synchronized (object) {
                this.protocol.setSyncArrived(true);
                this.protocol.getLockSyncAck().notify();
            }
        }
    }

    protected void doLastAsyncMessageAcked() {
        this.protocol.getUnAckedIrps().remove(this.msgId);
        this.protocol.setAsyncRetrans(0);
        this.protocol.fireStatusEvent(3);
    }

    protected void doLastAsyncMessageLost() {
        SioIrp irp = null;
        Integer msgId = null;
        try {
            this.protocol.doIrpSubmit(null, 'D', 0);
            this.protocol.doIrpSubmit(null, 'R', 0);
            Iterator it = this.protocol.getUnAckedIrps().keySet().iterator();
            while (it.hasNext()) {
                msgId = (Integer)it.next();
                irp = (SioIrp)this.protocol.getUnAckedIrps().get(msgId);
                this.protocol.doIrpSubmit(irp, 'W', this.protocol.getFlags(), msgId);
            }
            if (this.protocol.getLastSyncIrp() != null) {
                this.protocol.doIrpSubmit(this.protocol.getLastSyncIrp(), 'W', this.protocol.getFlags());
            }
            this.protocol.setAsyncRetrans(this.protocol.getAsyncRetrans() + 1);
            if (this.protocol.getAsyncRetrans() > this.protocol.getMaxAttempts()) {
                this.doAsyncLost(true);
            }
        }
        catch (SioException e) {
            this.processException(e);
        }
    }
}

