/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioException;
import com.ibm.jsio.os.sockets.SioImpUtil;
import com.ibm.jsio.os.sockets.SioReaderCallback;
import com.ibm.jsio.os.sockets.SioSocketHelper;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.EOFException;

public class SioMessageReader
implements Runnable {
    private SioReaderCallback callback = null;
    private SioSocketHelper socket = null;
    private boolean enabled = true;
    private Tracer tracer = TracerFactory.getInstance().createTracer("JSIO", SioImpUtil.getClassName(this));

    public SioMessageReader(SioReaderCallback c, SioSocketHelper s) {
        this.callback = c;
        this.socket = s;
    }

    public void run() {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> run()");
        }
        while (this.enabled) {
            try {
                this.callback.messageReceived(this.socket.receiveMessage());
            }
            catch (SioException e) {
                if (e.getOriginalException() instanceof EOFException) {
                    this.enabled = false;
                }
                if (!this.enabled) continue;
                if (this.tracer.isOn()) {
                    this.tracer.println(3, "Socket Exception");
                    this.tracer.println(3, "Closing Socket...");
                }
                try {
                    this.socket.finalize();
                }
                catch (SioException e1) {
                    this.callback.processException(e1);
                }
                if (this.tracer.isOn()) {
                    this.tracer.println(3, "Socket Closed!");
                }
                this.callback.processException(e);
            }
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- run()");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }
}

