/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioException;
import com.ibm.jsio.SioIrp;
import com.ibm.jsio.event.SioDeviceDataEvent;
import com.ibm.jsio.event.SioDeviceErrorEvent;
import com.ibm.jsio.event.SioDeviceStatusEvent;
import com.ibm.jsio.os.SioIrpImp;
import com.ibm.jsio.os.sockets.SioCommOnGoingState;
import com.ibm.jsio.os.sockets.SioDeviceImp;
import com.ibm.jsio.os.sockets.SioImpUtil;
import com.ibm.jsio.os.sockets.SioReaderCallback;
import com.ibm.jsio.os.sockets.SioServicesImp;
import com.ibm.jsio.os.sockets.SioSocketHelper;
import com.ibm.jsio.os.sockets.SioState;
import com.ibm.jsio.os.sockets.SioTimer;
import com.ibm.jsio.os.sockets.SioWaitResetCompleteState;
import com.ibm.jutil.Timerable;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.util.HashMap;
import java.util.TreeMap;

public class SioProtocol
implements SioReaderCallback,
Timerable {
    private SioIrp lastSyncIrp = null;
    private int syncRetrans = 0;
    private int asyncRetrans = 0;
    private Object lockSyncAck = new Object();
    private Object lockAsyncAck = new Object();
    private Object lockWait = new Object();
    private int messageId = 0x30303030;
    private int syncMsgId = -1;
    private SioState state = null;
    private SioDeviceImp device = null;
    private SioSocketHelper socket = null;
    private int connectionId = 0;
    private byte[] lastSyncMsg = null;
    private HashMap states = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("JSIO", SioImpUtil.getClassName(this));
    private TreeMap unAckedIrps = new TreeMap();
    private SioIrp emptyIrp = new SioIrpImp();
    private int flags = 0;
    private byte[] controlMessage = null;
    private boolean syncArrived = false;
    private boolean asyncArrived = false;
    private boolean controlMsgArrived = false;
    private boolean communicationLost = false;
    private boolean communicationError = false;
    private SioTimer timer = new SioTimer(this);
    private boolean timerEnabled = false;
    private boolean timeout = false;
    private boolean ackFailed = false;
    public static final int DATA_LENGTH_INDEX = 22;
    public static final int SERVER_CONN_ID_INDEX = 10;
    public static final int SERVER_CONN_ID_LENGTH = 4;
    public static final int MSG_ID_INITIAL_INDEX = 14;
    public static final int TYPE_OF_MSG_INDEX = 7;
    public static final byte CONNECTION_ID_LENGTH = 4;
    public static final String OPEN_MODE = "N";
    public static final String OPEN_MODE_OPTION = "0000";
    public static final String OPEN_COMMAND = "N 0000";
    public static int CONNECTION_ID_INITIAL_INDEX = 9;
    public static final int ACK_MSG_LENGTH = "<ack>OK ".length() + 4 + "</ack>".length();
    public static final char MSG_NEW_MESSAGE_RECEIVED = 'N';
    public static final char MSG_LAST_MESSAGE_ACKED = 'A';
    public static final char MSG_LAST_MESSAGE_LOST = 'L';
    public static final char MSG_LAST_ACK_LOST = 'B';
    public static final char MSG_POWER_ON_RESET_SENT = 'P';
    public static final char MSG_NSA_RECEIVED = 'C';
    public static final char MSG_SNRM_SENT = 'S';
    public static final char MSG_COMMAND_REJECT_IN_PROGRESS = 'Q';
    public static final char MSG_POWER_ON_RESET_IN_PROGRESS = 'R';
    public static final char MSG_WRITE = 'W';
    public static final char MSG_DISCARD_ALL_DATA = 'D';
    public static final char MSG_RESTART_AFTER_ERROR = 'R';
    public static final char MSG_SNRM_SENT_NOT_ANSWERING_POLLS = 'G';
    public static final int FLAG_HIGH_PRIORITY = 1;
    public static final int FLAG_BUFFERED_DATA = 2;
    public static final int FLAG_RETRANSMITION = 32768;
    public static final int FLAG_NO_FLAG = 0;
    static /* synthetic */ Class class$com$ibm$jsio$os$sockets$SioCommOnGoingState;
    static /* synthetic */ Class class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState;

    public SioProtocol(SioDeviceImp d) {
        this.device = d;
        this.createStates();
        this.timer.setTime(SioServicesImp.TIMEOUT);
    }

    public void setCurrentState(Class s) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> setCurrentState()");
        }
        this.state = (SioState)this.states.get(s);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Changed State To: [" + SioImpUtil.getClassName(this.state) + "]");
        }
        this.tracer.println(3, "<-- setCurrentState()");
    }

    public void init() throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> init()");
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Connecting device on port..." + this.device.getTcpPort());
        }
        this.socket = new SioSocketHelper(SioServicesImp.SERVER_IP, this.device.getTcpPort());
        if (this.tracer.isOn()) {
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Device Connected");
        }
        this.setCurrentState(class$com$ibm$jsio$os$sockets$SioCommOnGoingState == null ? (class$com$ibm$jsio$os$sockets$SioCommOnGoingState = SioProtocol.class$("com.ibm.jsio.os.sockets.SioCommOnGoingState")) : class$com$ibm$jsio$os$sockets$SioCommOnGoingState);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- init()");
        }
    }

    public void exchangeVersion() throws SioException {
        this.timer.start();
        this.waitResponse();
        this.socket.submit("<version>2.0.0</version>");
    }

    public void start() throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> start()");
        }
        this.setCurrentState(class$com$ibm$jsio$os$sockets$SioCommOnGoingState == null ? (class$com$ibm$jsio$os$sockets$SioCommOnGoingState = SioProtocol.class$("com.ibm.jsio.os.sockets.SioCommOnGoingState")) : class$com$ibm$jsio$os$sockets$SioCommOnGoingState);
        this.state.setWaitingType("<open>");
        this.setControlMsgArrived(false);
        this.socket.submit("<open>N 0000</open>");
        this.waitResponse();
        if (SioImpUtil.checkValue(this.controlMessage, "<open>OK")) {
            this.connectionId = SioImpUtil.parseConnectionId(this.controlMessage);
            this.device.setOpen(true);
            if (!this.isDeviceOnline()) {
                this.device.close();
                throw new SioException("Can't open the device. The device is offline");
            }
            if (this.tracer.isOn()) {
                this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Device opened with connection ID: " + this.connectionId);
            }
        } else {
            throw new SioException("Can't open the device");
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- start()");
        }
    }

    public void close() throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> close()");
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Closing Connection: " + this.connectionId);
        }
        this.state.setWaitingType("<close>");
        this.setControlMsgArrived(false);
        this.socket.submit("<close>" + SioImpUtil.formatConnectionId(this.connectionId) + "</close>");
        this.waitResponse();
        if (!SioImpUtil.checkValue(this.state.getLastMsg(), "<close>OK")) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Close Failed" + new String(this.controlMessage));
            }
            throw new SioException("Can't close the device");
        }
        this.device.setOpen(false);
        this.device.killReader();
        this.timer.pleaseEnd();
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- close()");
        }
    }

    public static char getTypeOfMessage(byte[] msg) {
        return (char)msg[7];
    }

    public void fireStatusEvent(int status) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "Firing Status Event");
        }
        this.device.getEventHelper().fireStatusEvent(new SioDeviceStatusEvent(this.device, status));
    }

    public void fireErrorEvent(SioException exception, int error) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "Firing Error Event");
        }
        this.device.getEventHelper().fireErrorEvent(new SioDeviceErrorEvent(this.device, error, exception));
    }

    public void fireDataEvent(SioIrp irp, byte[] data) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "Firing Data Event");
        }
        this.device.getEventHelper().fireDataEvent(new SioDeviceDataEvent(this.device, irp, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void syncSubmit(SioIrp irp) throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> syncSubmit()");
        }
        this.lastSyncIrp = irp;
        this.syncArrived = false;
        this.communicationLost = false;
        this.communicationError = false;
        this.startTimer();
        this.state.syncSubmit(irp);
        Object object = this.lockSyncAck;
        synchronized (object) {
            if (!this.syncArrived) {
                try {
                    if (this.tracer.isOn()) {
                        this.tracer.println(3, "[" + System.currentTimeMillis() + "]" + "Waiting for device response");
                    }
                    this.lockSyncAck.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.stopTimer();
        if (this.syncRetrans > SioServicesImp.MAX_ATTEMPTS) {
            this.syncRetrans = 0;
            this.lastSyncIrp = null;
            this.lastSyncMsg = null;
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Communication Lost (MAX_ATTEMPTS) Exception");
            }
            throw new SioException("Communication with the device is lost");
        }
        if (this.communicationLost) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Communication Lost Exception");
            }
            throw new SioException("Communication with the device is lost");
        }
        if (this.communicationError) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Communication Error Exception");
            }
            throw new SioException("Device Communication Error");
        }
        if (this.ackFailed) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Communication Error Exception - Data too long");
            }
            throw new SioException("Communication Error Exception - Data too long");
        }
        if (this.timeout) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Rs485 Server is not responding. TimeOut");
            }
            this.timeout = false;
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "SyncSubmit done.");
            this.tracer.println(3, "<-- syncSubmit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void asyncSubmit(SioIrp irp) throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> asyncSubmit()");
        }
        this.asyncArrived = false;
        this.startTimer();
        this.state.asyncSubmit(irp);
        Object object = this.lockAsyncAck;
        synchronized (object) {
            if (!this.asyncArrived) {
                try {
                    this.lockAsyncAck.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.stopTimer();
        if (this.ackFailed) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Communication Error Exception - Data too long");
            }
            throw new SioException("Communication Error Exception - Data too long");
        }
        if (this.timeout) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Rs485 Server is not responding. TimeOut");
            }
            this.timeout = false;
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "AsyncSubmit done.");
            this.tracer.println(3, "<-- asyncSubmit()");
        }
    }

    public byte[] createSubmitMessage(SioIrp irp, char type, int flag, Integer id) {
        int intId = 0;
        int tagLength = "<rs485>".length();
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> createSubmitMessage()");
        }
        if (irp == null) {
            irp = this.emptyIrp;
        }
        byte[] data = new byte[tagLength + 11 + irp.getLength() + "</rs485>".length()];
        System.arraycopy("<rs485>".getBytes(), 0, data, 0, tagLength);
        data[tagLength] = (byte)type;
        data[tagLength + 1] = (byte)((flag & 0xFF00) >> 8);
        data[tagLength + 2] = (byte)(flag & 0xFF);
        if (id == null) {
            data[tagLength + 3] = (byte)((this.messageId & 0xFF000000) >> 24);
            data[tagLength + 4] = (byte)((this.messageId & 0xFF0000) >> 16);
            data[tagLength + 5] = (byte)((this.messageId & 0xFF00) >> 8);
            data[tagLength + 6] = (byte)(this.messageId & 0xFF);
            ++this.messageId;
        } else {
            intId = id;
            data[tagLength + 3] = (byte)((intId & 0xFF000000) >> 24);
            data[tagLength + 4] = (byte)((intId & 0xFF0000) >> 16);
            data[tagLength + 5] = (byte)((intId & 0xFF00) >> 8);
            data[tagLength + 6] = (byte)(intId & 0xFF);
        }
        data[tagLength + 7] = this.device.getAddressWaitTime();
        data[tagLength + 8] = this.device.getInterByteWaitTime();
        data[tagLength + 9] = (byte)((irp.getLength() & 0xFF00) >> 8);
        data[tagLength + 10] = (byte)(irp.getLength() & 0xFF);
        System.arraycopy(irp.getData(), irp.getOffset(), data, tagLength + 11, irp.getLength());
        System.arraycopy("</rs485>".getBytes(), 0, data, tagLength + 11 + irp.getLength(), "</rs485>".length());
        if (this.tracer.isOn()) {
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Creating RS485 " + type + " packet: " + SioImpUtil.format(data));
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- createSubmitMessage()");
        }
        return data;
    }

    public byte[] extractData(byte[] data) {
        int length = 0;
        length = data[22] & 0xFF;
        length = (length << 8) + (data[23] & 0xFF);
        byte[] temp = new byte[length];
        System.arraycopy(data, 24, temp, 0, length);
        return temp;
    }

    public void doIrpAsyncSubmit(SioIrp irp, char type, int flag) throws SioException {
        this.socket.submit(this.createSubmitMessage(irp, type, flag, null));
        this.unAckedIrps.put(new Integer(this.messageId - 1), irp);
        if (this.tracer.isOn()) {
            this.tracer.println(2, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "AsyncSubmit Data -> " + SioImpUtil.formatData(irp));
        }
    }

    public void doIrpSyncSubmit(SioIrp irp, char type, int flag) throws SioException {
        this.lastSyncMsg = this.createSubmitMessage(irp, type, flag, null);
        this.syncMsgId = this.messageId - 1;
        this.socket.submit(this.lastSyncMsg);
        if (this.tracer.isOn()) {
            this.tracer.println(2, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "SyncSubmit Data -> " + SioImpUtil.formatData(irp));
        }
    }

    public void doIrpSubmit(SioIrp irp, char type, int flag) throws SioException {
        this.socket.submit(this.createSubmitMessage(irp, type, flag, null));
        if (irp != null) {
            if (this.tracer.isOn()) {
                this.tracer.println(2, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Submit Data -> " + SioImpUtil.formatData(irp));
            }
        } else if (this.tracer.isOn()) {
            this.tracer.println(2, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Submit Data -> ");
        }
    }

    public void doIrpSubmit(SioIrp irp, char type, int flag, Integer msgId) throws SioException {
        this.socket.submit(this.createSubmitMessage(irp, type, flag, msgId));
        if (irp != null) {
            if (this.tracer.isOn()) {
                this.tracer.println(2, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Submit Data -> " + SioImpUtil.formatData(irp));
            }
        } else if (this.tracer.isOn()) {
            this.tracer.println(2, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Submit Data -> ");
        }
    }

    public boolean isAsyncPending() {
        return !this.unAckedIrps.isEmpty();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getSyncMsgId() {
        return this.syncMsgId;
    }

    public SioIrp getLastSyncIrp() {
        return this.lastSyncIrp;
    }

    public Object getLockSyncAck() {
        return this.lockSyncAck;
    }

    public Object getLockAsyncAck() {
        return this.lockAsyncAck;
    }

    public TreeMap getUnAckedIrps() {
        return this.unAckedIrps;
    }

    public SioSocketHelper getSocket() {
        return this.socket;
    }

    public void messageReceived(byte[] msg) {
        if (msg != null) {
            this.state.messageReceived(msg);
        }
    }

    public Object getLockWait() {
        return this.lockWait;
    }

    public void setControlMessage(byte[] data) {
        this.controlMessage = data;
    }

    public void setDeviceAttached(boolean attached) {
        this.device.setDeviceAttached(attached);
    }

    public boolean isDeviceAttached() {
        return this.device.isDeviceAttached();
    }

    public void processException(SioException e) {
        this.state.processException(e);
    }

    public void sendAck(byte[] msg) throws SioException {
        byte[] ackMsg = new byte[ACK_MSG_LENGTH];
        System.arraycopy("<ack>OK ".getBytes(), 0, ackMsg, 0, "<ack>OK ".length());
        System.arraycopy(msg, 10, ackMsg, "<ack>OK ".length(), 4);
        System.arraycopy("</ack>".getBytes(), 0, ackMsg, "<ack>OK ".length() + 4, "</ack>".length());
        this.socket.submit(ackMsg);
    }

    public void setSyncArrived(boolean b) {
        this.syncArrived = b;
    }

    public void setCommunicationError(boolean b) {
        this.communicationError = b;
    }

    public void setCommunicationLost(boolean b) {
        this.communicationLost = b;
    }

    public void setAsyncArrived(boolean b) {
        this.asyncArrived = b;
    }

    public int getAsyncRetrans() {
        return this.asyncRetrans;
    }

    public int getSyncRetrans() {
        return this.syncRetrans;
    }

    public void setAsyncRetrans(int i) {
        this.asyncRetrans = i;
    }

    public void setSyncRetrans(int i) {
        this.syncRetrans = i;
    }

    public void setLastSyncIrp(SioIrp irp) {
        this.lastSyncIrp = irp;
    }

    public byte getDeviceNumber() {
        return this.device.getDeviceNumber();
    }

    public int getMaxAttempts() {
        return SioServicesImp.MAX_ATTEMPTS;
    }

    public void setAckFailed(boolean b) {
        this.ackFailed = b;
    }

    public void setControlMsgArrived(boolean b) {
        this.controlMsgArrived = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired() {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> timerExpired");
        }
        if (this.timerEnabled) {
            this.timeout = true;
            this.syncArrived = true;
            Object object = this.lockSyncAck;
            synchronized (object) {
                this.lockSyncAck.notify();
            }
            this.asyncArrived = true;
            object = this.lockAsyncAck;
            synchronized (object) {
                this.lockAsyncAck.notify();
            }
            object = this.lockWait;
            synchronized (object) {
                this.lockWait.notify();
            }
        }
    }

    public void closeSocket() {
        block4: {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Closing Socket...");
            }
            try {
                this.socket.close();
            }
            catch (SioException e1) {
                if (!this.tracer.isOn()) break block4;
                this.tracer.println(3, "Couldn't close socket.");
            }
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "Socket Closed!");
        }
    }

    private void createStates() {
        this.states = new HashMap();
        this.states.put(class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState == null ? (class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState = SioProtocol.class$("com.ibm.jsio.os.sockets.SioWaitResetCompleteState")) : class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState, new SioWaitResetCompleteState(this));
        this.states.put(class$com$ibm$jsio$os$sockets$SioCommOnGoingState == null ? (class$com$ibm$jsio$os$sockets$SioCommOnGoingState = SioProtocol.class$("com.ibm.jsio.os.sockets.SioCommOnGoingState")) : class$com$ibm$jsio$os$sockets$SioCommOnGoingState, new SioCommOnGoingState(this));
    }

    private void stopTimer() {
        this.timerEnabled = false;
        this.timer.stop();
        this.timer.setTime(SioServicesImp.TIMEOUT);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "[" + System.currentTimeMillis() + "]" + "Timer Stopped");
        }
    }

    private void startTimer() {
        this.timerEnabled = true;
        this.timer.start();
        if (this.tracer.isOn()) {
            this.tracer.println(3, "[" + System.currentTimeMillis() + "]" + "Timer Restarted");
        }
    }

    private boolean isDeviceOnline() throws SioException {
        this.state.setWaitingType("<status>");
        this.setControlMsgArrived(false);
        this.socket.submit("<status></status>");
        this.waitResponse();
        return SioImpUtil.checkValue(this.controlMessage, "<status>ONLINE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitResponse() throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> waitResponse(" + this.state.getWaitingType() + ")");
        }
        this.startTimer();
        Object object = this.lockWait;
        synchronized (object) {
            if (!this.controlMsgArrived) {
                if (this.tracer.isOn()) {
                    this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Locking until expected response");
                }
                try {
                    this.lockWait.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.stopTimer();
        if (this.timeout) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Rs485 Server is not responding. TimeOut");
                this.tracer.println(3, "Waited message: " + this.state.getWaitingType() + " Last Message: " + SioImpUtil.format(this.state.getLastMsg()));
            }
            this.timeout = false;
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.getDeviceNumber() & 0xFF) + "} " + "Lock released");
            this.tracer.println(3, "<-- waitResponse()");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

