/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.RootSioSlot;
import com.ibm.jsio.SioDevice;
import com.ibm.jsio.SioException;
import com.ibm.jsio.SioServices;
import com.ibm.jsio.SioSlot;
import com.ibm.jsio.event.DefaultSioServicesEventHelper;
import com.ibm.jsio.event.SioServicesEvent;
import com.ibm.jsio.event.SioServicesEventHelper;
import com.ibm.jsio.event.SioServicesListener;
import com.ibm.jsio.os.sockets.RootSioSlotImp;
import com.ibm.jsio.os.sockets.SioImpUtil;
import com.ibm.jsio.os.sockets.SioMessageReader;
import com.ibm.jsio.os.sockets.SioQueryDeviceElement;
import com.ibm.jsio.os.sockets.SioQueryParser;
import com.ibm.jsio.os.sockets.SioQueryXercesParser;
import com.ibm.jsio.os.sockets.SioReaderCallback;
import com.ibm.jsio.os.sockets.SioSlotImp;
import com.ibm.jsio.os.sockets.SioSocketHelper;
import com.ibm.jsio.os.sockets.SioTimer;
import com.ibm.jutil.Timerable;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class SioServicesImp
implements SioServices,
SioReaderCallback,
Timerable {
    public static HashMap defaultAWaitHashMap = new HashMap();
    public static HashMap defaultBWaitHashMap = new HashMap();
    public static int TIMEOUT = 5000;
    public static int CONNECT_TIMEOUT = 20000;
    public static String SERVER_IP = "127.0.0.1";
    public static int SERVER_PORT = 42104;
    public static int MAX_ATTEMPTS = 3;
    private ArrayList newDevices = new ArrayList();
    private RootSioSlotImp rootSlot = new RootSioSlotImp();
    private List devices = null;
    private SioQueryParser parser = new SioQueryXercesParser();
    private SioSocketHelper controlSocket = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("JSIO", SioImpUtil.getClassName(this));
    private Thread t1 = null;
    private Object queryLock = new Object();
    private SioServicesEventHelper eventHelper = new DefaultSioServicesEventHelper();
    private boolean timerEnabled = false;
    private SioTimer timer = new SioTimer(this);
    private boolean timeout = false;
    private boolean queryArrived = false;
    private Properties properties = new Properties();

    public SioServicesImp() throws SecurityException, SioException {
        this.timer.setTime(TIMEOUT);
        SioImpUtil.loadDefaultAWait(defaultAWaitHashMap);
        SioImpUtil.loadDefaultBWait(defaultBWaitHashMap);
        this.setupProperties();
    }

    public RootSioSlot getRootSioSlot() throws SioException, SecurityException {
        this.init();
        return this.rootSlot;
    }

    public void addSioServicesListener(SioServicesListener listener) {
        this.eventHelper.addSioServicesListener(listener);
    }

    public void removeSioServicesListener(SioServicesListener listener) {
        this.eventHelper.removeSioServicesListener(listener);
    }

    public void checkPermission() throws SecurityException {
    }

    public String getApiVersion() {
        return "2.0.0";
    }

    public String getImpVersion() {
        return "2.0.0";
    }

    public String getImpDescription() {
        return "(C) Copyright IBM Corp. 2004. Default JSio Implementation Layer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SecurityException, SioException {
        if (this.controlSocket == null) {
            this.controlSocket = new SioSocketHelper();
            this.controlSocket.connect(SERVER_IP, SERVER_PORT, CONNECT_TIMEOUT);
            this.t1 = new Thread(new SioMessageReader(this, this.controlSocket));
            this.t1.start();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.controlSocket.submit("<query></query>");
            this.startTimer();
            if (!this.queryArrived) {
                Object object = this.queryLock;
                synchronized (object) {
                    try {
                        this.queryLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.queryArrived = false;
            this.stopTimer();
            if (this.timeout) {
                throw new SioException("Rs485 Timeout. Query message was not responded");
            }
        }
    }

    public SioSlot createSioSlot(RootSioSlot rootSlot, byte b) {
        return ((RootSioSlotImp)rootSlot).addSlot(b);
    }

    public SioDevice createSioDevice(SioSlot sioSlot, byte deviceNumber, byte portNumber, int tcpPort) {
        return ((SioSlotImp)sioSlot).addDevice(deviceNumber, portNumber, tcpPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(byte[] msg) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> messageReceived()");
        }
        if (SioImpUtil.checkValue(msg, "<query>") || SioImpUtil.checkValue(msg, "<update>")) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Response: " + SioImpUtil.format(msg));
                this.tracer.println(3, "Parsing Query Response");
            }
            try {
                this.devices = this.parser.parse(new String(msg));
            }
            catch (SioException e) {
                if (this.tracer.isOn()) {
                    this.tracer.println(3, "Parsing Error. Instantiation failed.");
                }
                return;
            }
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Query Response Parsed. Listing and instantiating devices and slots: ");
            }
            if (SioImpUtil.checkValue(msg, "<update>")) {
                this.createNewDevices();
            }
            this.instantiateDevices(this.devices, msg);
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- messageReceived()");
        }
        this.queryArrived = true;
        Object object = this.queryLock;
        synchronized (object) {
            this.queryLock.notifyAll();
        }
    }

    public void processException(SioException e) {
        if (this.tracer.isOn()) {
            this.tracer.println((Object)e);
        }
    }

    public static byte getDefaultAWait(byte deviceNumber) {
        Integer dn = new Integer(deviceNumber & 0xFF);
        if (defaultAWaitHashMap.containsKey(dn)) {
            return (Byte)defaultAWaitHashMap.get(dn);
        }
        return -64;
    }

    public static byte getDefaultBWait(byte deviceNumber) {
        Integer dn = new Integer(deviceNumber & 0xFF);
        if (defaultBWaitHashMap.containsKey(dn)) {
            return (Byte)defaultBWaitHashMap.get(dn);
        }
        return -112;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired() {
        if (this.timerEnabled) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "--> timerExpired");
            }
            this.timeout = true;
            Object object = this.queryLock;
            synchronized (object) {
                this.queryLock.notify();
            }
        }
    }

    protected void stopTimer() {
        this.timerEnabled = false;
        this.timer.stop();
        this.timer.setTime(TIMEOUT);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "[" + System.currentTimeMillis() + "]" + "Timer Stopped");
        }
    }

    protected void startTimer() {
        this.timerEnabled = true;
        this.timer.start();
        if (this.tracer.isOn()) {
            this.tracer.println(3, "[" + System.currentTimeMillis() + "]" + "Timer Restarted");
        }
    }

    private void instantiateDevices(List devices, byte[] msg) {
        SioQueryDeviceElement currentDevice = null;
        SioSlot sioSlot = null;
        SioDevice sioDevice = null;
        Iterator it = devices.iterator();
        while (it.hasNext()) {
            currentDevice = (SioQueryDeviceElement)it.next();
            sioSlot = this.createSioSlot(this.rootSlot, currentDevice.getSlotNumber());
            sioDevice = this.createSioDevice(sioSlot, currentDevice.getDeviceNumber(), currentDevice.getPortNumber(), currentDevice.getTcpPort());
            if (!SioImpUtil.checkValue(msg, "<update>") || !this.newDevices.contains(currentDevice)) continue;
            this.eventHelper.fireSioDeviceAttachedEvent(new SioServicesEvent(this, sioDevice));
        }
        if (this.tracer.isOn() && this.rootSlot != null && currentDevice != null) {
            this.tracer.println(3, (Object)currentDevice);
            this.tracer.println(3, "Slots and Devices instantiated. Showing structure: ");
            this.tracer.println(3, (Object)this.rootSlot);
        }
    }

    private void createNewDevices() {
        SioQueryDeviceElement currentDevice = null;
        Iterator it = this.devices.iterator();
        while (it.hasNext()) {
            currentDevice = (SioQueryDeviceElement)it.next();
            if (this.rootSlot.hasSlot(currentDevice.getSlotNumber())) {
                SioSlotImp slot = this.rootSlot.getSlot(currentDevice.getSlotNumber());
                if (slot.hasDevice(currentDevice.getDeviceNumber(), currentDevice.getPortNumber())) continue;
                this.newDevices.add(currentDevice);
                continue;
            }
            this.newDevices.add(currentDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupProperties() {
        block14: {
            block13: {
                i = null;
                try {
                    try {
                        i = ClassLoader.getSystemResourceAsStream("jsio.properties");
                        if (i == null) {
                            if (this.tracer.isOn()) {
                                this.tracer.println(3, "Can't load properties file jsio.properties. Using DEFAULTS");
                            }
                            var4_2 = null;
                            break block13;
                        }
                        this.properties.load(i);
                        SioServicesImp.SERVER_IP = this.getProperty("jsio.os.sockets.ip", "127.0.0.1");
                        SioServicesImp.SERVER_PORT = this.getProperty("jsio.os.sockets.port", 42104);
                        SioServicesImp.TIMEOUT = this.getProperty("jsio.os.sockets.timeout", 5000);
                        SioServicesImp.MAX_ATTEMPTS = this.getProperty("jsio.os.sockets.maxattempts", 3);
                        SioServicesImp.CONNECT_TIMEOUT = this.getProperty("jsio.os.sockets.connect_timeout", 20000);
                        break block14;
                    }
                    catch (IOException e1) {
                        if (this.tracer.isOn()) {
                            this.tracer.println(3, "Can't load properties file jsio.properties. Using DEFAULTS");
                            this.tracer.println((Object)e1);
                        }
                        var4_4 = null;
                        try {
                            if (i == null) return;
                            i.close();
                            return;
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                }
                catch (Throwable var3_11) {
                    var4_5 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 149->160)] { 
lbl34:
                    // 1 sources

                    if (i == null) throw var3_11;
                    i.close();
                    throw var3_11;
lbl37:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var3_11;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 149->160)] { 
lbl42:
            // 1 sources

            if (i == null) return;
            i.close();
            return;
lbl45:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var4_3 = null;
        try {}
        catch (IOException e) {}
        if (i == null) return;
        i.close();
        return;
    }

    private String getProperty(String property, String defaultValue) {
        if (this.properties.containsKey(property) && this.tracer.isOn()) {
            this.tracer.println(3, "Property loaded: " + property + " = " + (String)this.properties.get(property));
            return (String)this.properties.get(property);
        }
        return defaultValue;
    }

    private int getProperty(String property, int defaultValue) {
        if (this.properties.containsKey(property)) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Property loaded: " + property + " = " + Integer.decode((String)this.properties.get(property)));
            }
            return Integer.decode((String)this.properties.get(property));
        }
        return defaultValue;
    }
}

