/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioDevice;
import com.ibm.jsio.SioSlot;
import com.ibm.jsio.os.sockets.SioDeviceImp;
import com.ibm.jsio.os.sockets.SioServicesImp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SioSlotImp
implements SioSlot {
    protected byte sioSlotNumber = 0;
    protected byte numberOfSioDevices = 0;
    protected ArrayList devicesList = new ArrayList();

    public SioSlotImp(byte slotNumber) {
        this.sioSlotNumber = slotNumber;
    }

    public byte getSioSlotNumber() {
        return this.sioSlotNumber;
    }

    public byte getNumberOfSioDevices() {
        return this.numberOfSioDevices;
    }

    public List getAttachedSioDevices() {
        SioDevice device = null;
        ArrayList<SioDevice> definitiveList = new ArrayList<SioDevice>();
        List currentList = (List)this.devicesList.clone();
        Iterator it = currentList.iterator();
        while (it.hasNext()) {
            device = (SioDevice)it.next();
            if (!device.isDeviceAttached()) continue;
            definitiveList.add(device);
        }
        return definitiveList;
    }

    public SioDevice addDevice(byte deviceNumber, byte portNumber, int tcpPort) {
        SioDevice device = null;
        boolean exists = false;
        Iterator it = this.devicesList.iterator();
        while (it.hasNext() && !exists) {
            device = (SioDevice)it.next();
            if (device.getDeviceNumber() != deviceNumber || device.getPortNumber() != portNumber) continue;
            exists = true;
        }
        if (!exists) {
            SioDeviceImp sioDeviceImp = new SioDeviceImp();
            sioDeviceImp.setDeviceNumber(deviceNumber);
            sioDeviceImp.setPortNumber(portNumber);
            sioDeviceImp.setTcpPort(tcpPort);
            sioDeviceImp.setSioSlot(this);
            sioDeviceImp.setAddressWaitTime(SioServicesImp.getDefaultAWait(deviceNumber));
            sioDeviceImp.setInterByteWaitTime(SioServicesImp.getDefaultBWait(deviceNumber));
            this.devicesList.add(sioDeviceImp);
            this.numberOfSioDevices = (byte)(this.numberOfSioDevices + 1);
            return sioDeviceImp;
        }
        return device;
    }

    public boolean hasDevice(byte deviceNumber, byte portNumber) {
        SioDeviceImp device = null;
        Iterator it = this.devicesList.iterator();
        while (it.hasNext()) {
            device = (SioDeviceImp)it.next();
            if (device.getDeviceNumber() != deviceNumber || device.getPortNumber() != portNumber) continue;
            return true;
        }
        return false;
    }
}

