/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioException;
import com.ibm.jsio.os.sockets.SioImpUtil;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SioSocketHelper {
    private Socket sock = null;
    private DataInputStream in;
    private DataOutputStream out;
    private int tcpPort = 0;
    private String ip = null;
    private boolean enabled;
    private Tracer tracer = TracerFactory.getInstance().createTracer("JSIO", SioImpUtil.getClassName(this));
    private byte[] lengthBuffer = new byte[2];
    public static final int MAX_MESSAGE_SIZE = 2048;
    public static final byte LENGTH_SIZE = 2;

    public SioSocketHelper() {
    }

    public SioSocketHelper(String ip, int port) throws SioException {
        this.tcpPort = port;
        this.ip = ip;
        this.connect(ip, this.tcpPort, 0);
        this.enabled = true;
    }

    public SioSocketHelper(String ip, int port, int connectTimeout) throws SioException {
        this.tcpPort = port;
        this.ip = ip;
        this.connect(ip, this.tcpPort, connectTimeout);
        this.enabled = true;
    }

    public void connect(String ip, int tcpPort, int connectTimeout) throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> connect()");
        }
        this.tcpPort = tcpPort;
        try {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Trying to connect to " + ip + ":" + tcpPort);
            }
            this.sock = new Socket();
            this.sock.connect(new InetSocketAddress(ip, tcpPort), connectTimeout);
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Connected!");
            }
        }
        catch (IOException e) {
            this.tracer.println((Object)e);
            throw new SioException("Could not connect to port " + tcpPort + ". Please check that AIPCtrl is running", e);
        }
        try {
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
        }
        catch (IOException e) {
            if (this.tracer.isOn()) {
                this.tracer.println((Object)e);
            }
            throw new SioException("Failed to get socket streams" + tcpPort, e);
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- connect()");
        }
    }

    public void submit(String data) throws SioException {
        this.submit(data.getBytes());
    }

    public synchronized void submit(byte[] data) throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> submit()");
        }
        byte[] buffer = new byte[data.length + 3];
        buffer[0] = (byte)((data.length & 0xFF00) >> 8);
        buffer[1] = (byte)(data.length & 0xFF);
        System.arraycopy(data, 0, buffer, 2, data.length);
        buffer[buffer.length - 1] = 22;
        if (this.tracer.isOn()) {
            this.tracer.println(3, "[" + System.currentTimeMillis() + "]Submitting Data: " + SioImpUtil.format(buffer));
        }
        try {
            this.out.write(buffer);
        }
        catch (IOException e) {
            if (this.tracer.isOn()) {
                this.tracer.println((Object)e);
            }
            throw new SioException("Couldn't submit data to protocol stack.", e);
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- submit()");
        }
    }

    public byte[] receiveMessage() throws SioException {
        byte[] msg;
        block14: {
            int i = 0;
            int length = 0;
            int temp = 0;
            msg = null;
            byte[] data = new byte[2048];
            this.lengthBuffer = new byte[2];
            try {
                this.in.readFully(this.lengthBuffer);
                if (this.tracer.isOn()) {
                    this.tracer.println(3, "--> receiveMessage()");
                }
                length = this.lengthBuffer[0] & 0xFF;
                length = (length << 8) + (this.lengthBuffer[1] & 0xFF);
                if (this.tracer.isOn()) {
                    this.tracer.println(3, "Receiving Message of Length " + length + ": ");
                }
                if (length > 2048) {
                    if (this.tracer.isOn()) {
                        this.tracer.println(3, "Invalid Message Length");
                    }
                    throw new SioException("Invalid Message Length");
                }
                while (i <= length) {
                    temp = this.in.read();
                    if (temp == -1) continue;
                    data[i] = (byte)(temp & 0xFF);
                    ++i;
                }
                if (data[length] != 22) {
                    if (length > 2048) {
                        if (this.tracer.isOn()) {
                            this.tracer.println(3, "Invalid Message Length");
                        }
                        throw new SioException("Invalid Message Length");
                    }
                    throw new SioException("Invalid Message Length");
                }
                msg = new byte[i - 1];
                System.arraycopy(data, 0, msg, 0, i - 1);
                if (this.tracer.isOn()) {
                    this.tracer.println(3, "[" + System.currentTimeMillis() + "]" + SioImpUtil.format(msg));
                }
                if (this.tracer.isOn()) {
                    this.tracer.println(3, "<-- receiveMessage()");
                }
            }
            catch (EOFException e1) {
                throw new SioException("Socket is gone", e1);
            }
            catch (Exception e) {
                if (!this.enabled) break block14;
                if (this.tracer.isOn()) {
                    this.tracer.println((Object)e);
                }
                throw new SioException("Could not read data from socket on port " + this.tcpPort, e);
            }
        }
        return msg;
    }

    public void close() throws SioException {
        this.clean();
    }

    private void clean() throws SioException {
        try {
            this.enabled = false;
            this.in.close();
            this.out.close();
            this.sock.close();
        }
        catch (IOException e) {
            throw new SioException("Could not close socket on port " + this.tcpPort, e);
        }
    }

    protected void finalize() throws SioException {
        this.clean();
    }
}

