/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioException;
import com.ibm.jsio.SioIrp;
import com.ibm.jsio.os.SioIrpRecyclable;
import com.ibm.jsio.os.sockets.SioImpUtil;
import com.ibm.jsio.os.sockets.SioProtocol;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.util.Iterator;

public abstract class SioState {
    protected Tracer tracer = TracerFactory.getInstance().createTracer("JSIO", SioImpUtil.getClassName(this));
    protected SioProtocol protocol = null;
    protected boolean isProcessed = false;
    protected String waitingType = "<version>";
    protected byte[] lastMsg = null;
    static /* synthetic */ Class class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState;

    public SioState(SioProtocol protocol) {
        this.protocol = protocol;
    }

    public abstract void messageReceived(byte[] var1);

    public void syncSubmit(SioIrp irp) throws SioException {
        throw new SioException("Can't submit data in the current state");
    }

    public void asyncSubmit(SioIrp irp) throws SioException {
        throw new SioException("Can't submit data in the current state");
    }

    public String getWaitingType() {
        return this.waitingType;
    }

    public void setWaitingType(String string) {
        this.waitingType = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processControlMessage() {
        Object object = this.protocol.getLockWait();
        synchronized (object) {
            if (SioImpUtil.checkValue(this.lastMsg, this.waitingType)) {
                this.protocol.setControlMsgArrived(true);
                this.protocol.getLockWait().notify();
            }
        }
    }

    public void processException(Exception e) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> processException()");
            this.tracer.println(3, "{Dev: " + Integer.toHexString(this.protocol.getDeviceNumber()) + "} " + SioImpUtil.getClassName(this) + " " + "Internal Error");
        }
        this.protocol.setCurrentState(class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState == null ? (class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState = SioState.class$("com.ibm.jsio.os.sockets.SioWaitResetCompleteState")) : class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState);
        this.protocol.fireErrorEvent(new SioException(e), 12);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- processException()");
        }
    }

    public byte[] getLastMsg() {
        return this.lastMsg;
    }

    protected void doAsyncLost(boolean fireError) {
        Object irp = null;
        Object key = null;
        if (this.protocol.isAsyncPending()) {
            Iterator it = this.protocol.getUnAckedIrps().keySet().iterator();
            while (it.hasNext()) {
                key = it.next();
                irp = this.protocol.getUnAckedIrps().remove(key);
                it = this.protocol.getUnAckedIrps().keySet().iterator();
                if (!(irp instanceof SioIrpRecyclable)) continue;
                ((SioIrpRecyclable)irp).recycle();
            }
            if (fireError) {
                this.protocol.fireErrorEvent(new SioException("Async Irps pending are lost"), 11);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPowerOnResetInProgress() {
        this.protocol.setCurrentState(class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState == null ? (class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState = SioState.class$("com.ibm.jsio.os.sockets.SioWaitResetCompleteState")) : class$com$ibm$jsio$os$sockets$SioWaitResetCompleteState);
        Object object = this.protocol.getLockSyncAck();
        synchronized (object) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Unlocking sync calls");
            }
            this.protocol.setSyncArrived(true);
            this.protocol.getLockSyncAck().notify();
        }
        this.doAsyncLost(false);
        if (this.protocol.isDeviceAttached()) {
            this.protocol.setDeviceAttached(false);
            this.protocol.fireStatusEvent(2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

