/**      (C) Copyright IBM Corporation 2006              l                     
                                                                           
      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          
      sample code created by IBM Corporation. This sample code is not      
      part of any standard or IBM product and is provided to you solely  
      for  the purpose of assisting you in the development of your       
      applications.  The code is provided "AS IS", without               
      warranty of any kind.  IBM shall not be liable for any damages     
      arising out of your use of the sample code, even if they have been 
      advised of the possibility of such damages.                          */


package com.ibm.jpos.tools.sdicc.demo;

import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;

import javax.swing.*;

import jpos.JposConst;
import jpos.JposException;


/**
 * Common Class for Graphical User Interface.  
 **/
public class DemoUI extends JPanel{
    
    
    //-------------------------------------------------------------------------
    // Public Methods
    //


    /**
     * @param lnames a string array with the logical names to display for this device
     * @param devDemo  
     * */
    public DemoUI(String [] lNames, DeviceDemo devDemo){
        super( new BorderLayout());
        deviceDemo = devDemo;
        deviceDemo.setUI(this);
        
        setBorder( BorderFactory.createLineBorder( Color.gray ) );
        JTabbedPane tabbedPane = new JTabbedPane( JTabbedPane.TOP );
        
        tabbedPane.addTab("Example", getSamplePanel());
        setLogicalNames(lNames);

            fileViewer = new FileViewerPanel();
            String fileName =  "com/ibm/jpos/tools/sdicc/demo/"+  
            deviceDemo.getDevCat() +   "Demo.java";
        fileViewer.setFile(fileName);
        tabbedPane.addTab("Source Code", fileViewer);
        add(tabbedPane);

    }

    /**
     * Flips the label of a button
     * @param prevLable the old label to replace
     * @param newLabel the new label
     * */
    public void flipButtonLabel(String prevLabel,String newLabel){
        flipButtonLabel(prevLabel,new String[]{newLabel});
    }
    
    /**
     * Flips the label of a button
     * @param prevLable the old label to replace
     * @param labels an array of 2 strings, the first is the button label and the second the tooltip text
     * */
    public void flipButtonLabel(String prevLabel,String[] newLabel){
        if(prevLabel == null ||
           newLabel  == null ||
           prevLabel.equals(newLabel[0])){
            return;
        }
        JButton b = (JButton)buttonsTable.get(prevLabel);
        if(b != null){
            b.setText(newLabel[0]);
            if(newLabel.length > 1){
                b.setToolTipText(newLabel[1]);
            }
            buttonsTable.remove(prevLabel);
            buttonsTable.put(newLabel[0],b);
        }
        
    }
    
    
     /**
      * display test in the User interface
      * @param s the string to display 
      *  */
  
    public void displayText(String s){
        if(! s.equals("")){
            deviceOutput.append(s+"\n");
            deviceOutput.setCaretPosition(deviceOutput.getText().length());
        }
    }
    
    /**
     * clear the text from the User Interface
     * */
    public void clearText(){
        deviceOutput.setText(null);
    }
    /**
     * displays an error message 
     *  @param errorMessage the error message to display
     * */
    public void displayInfoDialog(String message){
        JOptionPane.showMessageDialog(this,message,
                "Information",JOptionPane.INFORMATION_MESSAGE);
    }
    
    /**
     * display a ok/cancel   dialog
     * */
    public int displayConfirmDialog(String message){
        return JOptionPane.showConfirmDialog(this, 
                message, 
                "alert", 
                JOptionPane.OK_CANCEL_OPTION);
    }
    /**
     * return the selected Logical name in the ui
     * @return logical name selected
     * */
    public String getLogicalName(){
        return  logicalNamesComboBox.getSelectedItem().toString();
    }

    /**
     * return a string with the error description, based in the errorCode
     */
    public static String getErrorCodeName(int errorCode)
    {
        String errorCodeName = "";
        switch (errorCode)
        {
            case JposConst.JPOS_E_CLOSED:
                errorCodeName = "JPOS_E_CLOSED=";
                break;
            case JposConst.JPOS_E_CLAIMED:
                errorCodeName = "JPOS_E_CLAIMED=";
                break;
            case JposConst.JPOS_E_NOTCLAIMED:
                errorCodeName = "JPOS_E_NOTCLAIMED=";
                break;
            case JposConst.JPOS_E_NOSERVICE:
                errorCodeName = "JPOS_E_NOSERVICE=";
                break;
            case JposConst.JPOS_E_DISABLED:
                errorCodeName = "JPOS_E_DISABLED=";
                break;
            case JposConst.JPOS_E_ILLEGAL:
                errorCodeName = "JPOS_E_ILLEGAL=";
                break;
            case JposConst.JPOS_E_NOHARDWARE:
                errorCodeName = "JPOS_E_NOHARDWARE=";
                break;
            case JposConst.JPOS_E_OFFLINE:
                errorCodeName = "JPOS_E_OFFLINE=";
                break;
            case JposConst.JPOS_E_NOEXIST:
                errorCodeName = "JPOS_E_NOEXIST=";
                break;
            case JposConst.JPOS_E_EXISTS:
                errorCodeName = "JPOS_E_EXISTS=";
                break;
            case JposConst.JPOS_E_FAILURE:
                errorCodeName = "JPOS_E_FAILURE=";
                break;
            case JposConst.JPOS_E_TIMEOUT:
                errorCodeName = "JPOS_E_TIMEOUT=";
                break;
            case JposConst.JPOS_E_BUSY:
                errorCodeName = "JPOS_E_BUSY=";
                break;
            case JposConst.JPOS_E_EXTENDED:
                errorCodeName = "JPOS_E_EXTENDED=";
                break;
        }
        return errorCodeName + errorCode;
    }

    public void setLogicalNames(String []logicalNames){
        logicalNamesComboBox.removeAllItems();
        for (int i = 0; i < logicalNames.length; i++){
            logicalNamesComboBox.addItem(logicalNames[i]);
        }

    }
    
    /**
     * @return Returns the deviceDemo.
     */
    public DeviceDemo getDeviceDemo()
    {
        return deviceDemo;
    }

    /**
     * @param deviceDemo The deviceDemo to set.
     */
    public void setDeviceDemo(DeviceDemo devDemo)
    {
        deviceDemo = devDemo;
    }
    
    //-------------------------------------------------------------------------
    // Protected Methods
    //
    
    /**
     * Sets the gridx, gridy, gridwidth, and gridheight into 
     * the GridBagConstraints received
     * @return The same GridBagConstraints reference with the parameter 
     * values set 
     */
    protected GridBagConstraints setGBC(GridBagConstraints gbc, int gridx, 
            int gridy, int gridwidth,int gridheight)
    {
        gbc.gridx = gridx; 
        gbc.gridy = gridy; 
        gbc.gridwidth = gridwidth; 
        gbc.gridheight= gridheight;
        return gbc;
    }

    /**
     * Creates a Label with a speific FONT
     * @param text Text for this object
     * @param font Font for this label
     * @return A Label formmated with a specif FONT
     */
    protected JLabel createLabel( String text, Font font)
    {
        JLabel label = new JLabel(text);
        label.setFont(font);

        return label;
    }

    protected JButton createButton(String text,String toolTip){
        JButton button = new JButton(text);
        buttonsTable.put(text,button);
        button.setToolTipText(toolTip);
        button.addActionListener(actionListener);
        return button;
    }

    
    protected JComponent getSamplePanel()
    {
        JPanel mainPanel = createCommonPanel();
        logicalNamesComboBox.setEditable(false);
        deviceOutput.setEditable(false);
        return mainPanel;
    }


    protected JPanel createCommonPanel()
    {

        GridBagLayout gbl = new GridBagLayout();
        
        JPanel panel = new JPanel(gbl);
        panel.setBorder( BorderFactory.createLineBorder( Color.gray ) );
        
        
        GridBagConstraints  gbc = new GridBagConstraints();
        gbc.insets = new Insets(10,10,0,0);
        gbc.fill = GridBagConstraints.NONE;
        gbc.weighty = 0;
        
        //Components for first column
        panel.add( createLabel( TEXT_LOGICAL_NAME, DEFAULT_FONT_BOLD_14 ), 
                   setGBC( gbc, 1, 1, 1, 1));
        
        gbc.fill = GridBagConstraints.BOTH;
        panel.add(getDevicePanel(),setGBC( gbc,1,2, 5, 3));

        
        panel.add( createLabel( TEXT_DEVICE_OUTPUT, 
                DEFAULT_FONT_BOLD_14),
                setGBC( gbc, 1, 5, 1, 1));
            
        gbc.weightx = 100;
        gbc.weighty = 100;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.insets = new Insets(10,10,10,10);
        panel.add( new JScrollPane( deviceOutput ,
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED ),
                setGBC( gbc, 1, 6, 5, 1));
        JPanel bottom = new JPanel();

        gbc.weightx = 100;
        gbc.weighty = 0;
        gbc.fill = GridBagConstraints.BOTH;
        panel.add(bottom,setGBC( gbc,1,7,2,1));
        clearButton = new JButton(TEXT_CLEAR);
        clearButton.addActionListener(actionListener);
        bottom.add(clearButton);

         
        //Components for Second column
        gbc.insets = new Insets(10,10,0,10);
        gbc.weighty = 0;
        gbc.weightx = 100;
        panel.add( logicalNamesComboBox , setGBC( gbc, 2, 1, 3, 1));
        gbc.weightx = 0;
        

        return panel;
    }

    protected JPanel getDevicePanel(){
        String [][]buttonLabels = deviceDemo.getButtonLabels();
        if(buttonLabels == null){
            return devicePanel;
        }
        for (int i = 0; i < buttonLabels[0].length; i++){
            devicePanel.add(createButton(buttonLabels[0][i],
                                         buttonLabels[1][i]) );
         }
        return devicePanel;
        
    }

    //-------------------------------------------------------------------------
    // Instance Variables
    //
    public static final Font FONT_BOLD_HELVETICA_14  = new Font("Helvetica", Font.BOLD, 14);
    public static final Font DEFAULT_FONT_BOLD_14     = FONT_BOLD_HELVETICA_14;
    public static final String TEXT_LOGICAL_NAME       = "Logical Name";
    public static final String TEXT_DEVICE_OUTPUT="Device Output";
    public static final String TEXT_CLEAR="Clear";
    FileViewerPanel fileViewer;
    private JComboBox  logicalNamesComboBox = new JComboBox(); 
    private JButton clearButton;
    private JTextArea deviceOutput = new JTextArea( 5, 30 );
    private JPanel devicePanel  = new JPanel(new FlowLayout());
    private DemoActionListener actionListener = new DemoActionListener();
    private DeviceDemo deviceDemo;
    private static final long serialVersionUID = 1L;
    private Hashtable  buttonsTable = new Hashtable();
    private Cursor prevCursor; 


    
    //-------------------------------------------------------------------------
    // inner classes
    //

    class DemoActionListener implements ActionListener, Runnable
    {
        /**
         * Invoked when an action occurs.
         */
        public void actionPerformed(ActionEvent e)
        {
            if (e.getActionCommand().equals(TEXT_CLEAR))
            {
                clearText();
            }
            else
            {
                prevCursor = getCursor();
                setCursor(new Cursor(Cursor.WAIT_CURSOR));
                synchronized (startLock)
                {
                    ((JButton) e.getSource()).setEnabled(false);
                    actionParam = e;
                    actionRunner = new Thread(this, "actionRunner");
                    actionRunner.start();
                    try
                    {
                        startLock.wait();
                    }
                    catch (InterruptedException e1)
                    {
                    }
                }
            }
        }

        public void run()
        {
            ActionEvent actionEvent = null;
            synchronized (startLock)
            {
                actionEvent = actionParam;
                startLock.notifyAll();
            }
            try
            {
                deviceDemo.buttonPressed(actionEvent.getActionCommand());
            }
            catch (Exception ex)
            {
                if (ex instanceof JposException)
                {
                    JposException je = (JposException) ex;
                    String errMsg;
                    errMsg = "JposException("
                            + getErrorCodeName(je.getErrorCode()) + ","
                            + je.getErrorCodeExtended() + "," + je.getMessage()
                            + ")";
                    displayText(errMsg);
                }
                else
                {
                    displayText(ex.toString());
                }
            }
            setCursor(prevCursor);
            ((JButton)actionEvent.getSource()).setEnabled(true);
        }

        private Thread actionRunner;
        private Object startLock = new Object();
        private ActionEvent actionParam = null;
    }
}
