/**      (C) Copyright IBM Corporation 2006                                   
 
 DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          
 sample code created by IBM Corporation. This sample code is not      
 part of any standard or IBM product and is provided to you solely  
 for  the purpose of assisting you in the development of your       
 applications.  The code is provided "AS IS", without               
 warranty of any kind.  IBM shall not be liable for any damages     
 arising out of your use of the sample code, even if they have been 
 advised of the possibility of such damages.                          */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import jpos.JposConst;
import jpos.JposException;
import jpos.Scale;
import jpos.ScaleConst;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

/** 
 * ScaleDemo class implements a demo 
 * for the basic functionality of the Scale
 * @author 
 * */

public class ScaleDemo implements DeviceDemo, StatusUpdateListener
{

    //-------------------------------------------------------------------------
    // public methods
    //

    /**
     * main method creates a GUI to try ScaleDemo  
     **/

    public static void main(String args[])
    {
        // main needs one logical name as argument 
        if (args.length != 1)
        {
            System.out.println("Usage : \n"
               + "java com.ibm.jpos.tools.sdicc.demo.ScaleDemo <logicalName>");
            return;
        }
        //create this class that encapsulate the  jpos.Scale functionality
        DeviceDemo devDemo = new ScaleDemo();
        //create the UI for this demo
        DemoUI demoUI = new DemoUI(args, devDemo);
        //Add the ui to a JFrame
        JFrame mainWindow = new JFrame("ScaleDemo");
        mainWindow.setContentPane(demoUI);
        mainWindow.setSize(700, 500);
        //Center the Frame
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - mainWindow.getSize().width) / 2;
        int y = (screenSize.height - mainWindow.getSize().height) / 2;
        mainWindow.setLocation(x, y);
        mainWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainWindow.setVisible(true);

    }

    /**
     * @return a bidimensional arrays of strings
     *         the first array has the button labels
     *         the seccond array has the tooltips for those buttons 
     * */
    public String[][] getButtonLabels()
    {
        return new String[][]
        {
        { TEXT_SCALE_TEST },
        { TOOLTIP_TEXT_SCALE_TEST } };

    }

    /** 
     * @return the devCat for this device
     */
    public String getDevCat()
    {
        return "Scale";
    }

    /**
     * @param demoUI the ui to be used for this demo 
     * */
    public void setUI(DemoUI demoUI)
    {
        ui = demoUI;
        ui.displayText("#\n#Please remove any weight from the scale before running the test.\n#");
    }

    /**
     * @param button the button that was pressed
     */
    public void buttonPressed(String button) throws JposException
    {
        if (button.equals(TEXT_SCALE_TEST))
        {
            // start the device test
            doStartDeviceTest();
        }

    }

    /**
     * implementation of statusUpdateListener interface it is called when the
     * status of the device is updated
     * 
     * @param e
     *            the event generated by the device
     */
    public void statusUpdateOccurred(StatusUpdateEvent e)
    {
        int status = e.getStatus();

        String statusMsg = "StatusUpdateOccurred - ";
        switch (status)
        {
            case JposConst.JPOS_SUE_POWER_ONLINE:
                statusMsg += "JPOS_SUE_POWER_ONLINE";
                break;

            case JposConst.JPOS_SUE_POWER_OFF_OFFLINE:
            case JposConst.JPOS_SUE_POWER_OFFLINE:
                statusMsg += "JPOS_SUE_POWER_OFF_OFFLINE";
                break;

        }
        //display the status update received
        ui.displayText(statusMsg);

    }

    //-------------------------------------------------------------------------
    // UPOS Functionality
    //

    //-------------------------------------------------------------------------
    // Protected Methods
    //

    /**
     * open claim and enable the device, display some properties
     * and open the Scale
     * */
    protected void doStartDeviceTest() throws JposException
    {
        scale.open(ui.getLogicalName());
        ui.displayText("Open(\"" + ui.getLogicalName() + "\")");
        try
        {
            //Common Cap/Properties
            ui.displayText("DeviceControlVersion = "
                    + scale.getDeviceControlVersion());
            ui.displayText("DeviceControlDescription = "
                    + scale.getDeviceControlDescription());
            ui.displayText("DeviceServiceVersion = "
                    + scale.getDeviceServiceVersion());
            ui.displayText("DeviceServiceDescription = "
                    + scale.getDeviceServiceDescription());
            ui.displayText("CapCompareFirmwareVersion = "
                    + scale.getCapCompareFirmwareVersion());
            String capPowerReportingName = "";
            switch (scale.getCapPowerReporting())
            {
                case JposConst.JPOS_PR_NONE:
                    capPowerReportingName += "JPOS_PR_NONE = ";
                    break;
                case JposConst.JPOS_PR_STANDARD:
                    capPowerReportingName += "JPOS_PR_STANDARD = ";
                    break;
                case JposConst.JPOS_PR_ADVANCED:
                    capPowerReportingName += "JPOS_PR_ADVANCED = ";
                    break;
            }
            ui.displayText("CapPowerReporting = " + capPowerReportingName
                    + scale.getCapPowerReporting());
            ui.displayText("CapStatisticsReporting = "
                    + scale.getCapStatisticsReporting());
            ui.displayText("CapUpdateFirmware = "
                    + scale.getCapUpdateFirmware());
            ui.displayText("CapUpdateStatistics = "
                    + scale.getCapUpdateStatistics());
            scale.claim(1000);
            ui.displayText("Claim(1000)");
            scale.setDeviceEnabled(true);
            ui.displayText("setDeviceEnabled(true)");
            int weightUnit = scale.getWeightUnit();
            String weightUnitStr;
            switch (weightUnit)
            {
                case ScaleConst.SCAL_WU_GRAM:
                    weightUnitStr = "SCAL_WU_GRAM";
                    break;
                case ScaleConst.SCAL_WU_KILOGRAM:
                    weightUnitStr = "SCAL_WU_KILOGRAM";
                    break;
                case ScaleConst.SCAL_WU_POUND:
                    weightUnitStr = "SCAL_WU_POUND";
                    break;
                case ScaleConst.SCAL_WU_OUNCE:
                    weightUnitStr = "SCAL_WU_OUNCE";
                    break;
                default:
                    weightUnitStr = Integer.toString(weightUnit);

            }
            ui.displayText("WeightUnit Property = " + weightUnitStr);
            ui.displayText("#\n#please place "
                    + " a weight on the scale - timeout 10000 msecs\n#");
            int weight[] = new int[1];
            ui.displayText("readWeight(weight,10000)");
            scale.readWeight(weight, 10000);
            ui.displayText("Weight = " + weight[0]);
            // Specific Cap/Properties
        }
        finally
        {
            scale.close();
            ui.displayText("close()");
        }
    }

    //-------------------------------------------------------------------------
    // instance variables
    //
    private Scale scale = new Scale();

    private static DemoUI ui;

    //-------------------------------------------------------------------------
    // constants
    //
    /** Label for Start Button */
    private static final String TEXT_SCALE_TEST = "Start Scale Test";

    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_SCALE_TEST = "Open, claim " +
            "and enable  the Scale and read a weight from the scale";

}
