/**      (C) Copyright IBM Corporation 2006                                   
 
 DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          
 sample code created by IBM Corporation. This sample code is not      
 part of any standard or IBM product and is provided to you solely  
 for  the purpose of assisting you in the development of your       
 applications.  The code is provided "AS IS", without               
 warranty of any kind.  IBM shall not be liable for any damages     
 arising out of your use of the sample code, even if they have been 
 advised of the possibility of such damages.                          */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import jpos.JposConst;
import jpos.JposException;
import jpos.Scanner;
import jpos.ScannerConst;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

/** 
 * ScannerDemo class implements a demo 
 * for the basic functionality of the Scanner
 * @author 
 * */

public class ScannerDemo implements DeviceDemo, StatusUpdateListener,
        DataListener
{

    //-------------------------------------------------------------------------
    // public methods
    //

    /**
     * main method creates a GUI to try ScannerDemo  
     **/

    public static void main(String args[])
    {
        // main needs one logical name as argument 
        if (args.length != 1)
        {
            System.out.println("Usage : \n"+
               "java com.ibm.jpos.tools.sdicc.demo.ScannerDemo <logicalName>");
            return;
        }
        //create this class that encapsulate the  jpos.Scanner functionality
        DeviceDemo devDemo = new ScannerDemo();
        //create the UI for this demo
        DemoUI demoUI = new DemoUI(args, devDemo);
        //Add the ui to a JFrame
        JFrame mainWindow = new JFrame("ScannerDemo");
        mainWindow.setContentPane(demoUI);
        mainWindow.setSize(700, 500);
        //Center the Frame
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - mainWindow.getSize().width) / 2;
        int y = (screenSize.height - mainWindow.getSize().height) / 2;
        mainWindow.setLocation(x, y);
        mainWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainWindow.setVisible(true);

    }

    /**
     * @return a bidimensional arrays of strings
     *         the first array has the button labels
     *         the seccond array has the tooltips for those buttons 
     * */
    public String[][] getButtonLabels()
    {
        return new String[][]
        {
        { TEXT_START_DEVICE },
        { TOOLTIP_TEXT_DEVICE_START } };

    }

    /** 
     * @return the devCat for this device
     */
    public String getDevCat()
    {
        return "Scanner";
    }

    /**
     * @param demoUI the ui to be used for this demo 
     * */
    public void setUI(DemoUI demoUI)
    {
        ui = demoUI;
    }

    /**
     * @param button the button that was pressed
     */
    public void buttonPressed(String button) throws JposException
    {
        if (button.equals(TEXT_START_DEVICE))
        {
            // start the device test
            doStartDeviceTest();
            ui.flipButtonLabel(TEXT_START_DEVICE, new String[]
            { TEXT_STOP_DEVICE, TOOLTIP_TEXT_DEVICE_STOP });
        }
        else if (button.equals(TEXT_STOP_DEVICE))
        {
            ui.flipButtonLabel(TEXT_STOP_DEVICE, new String[]
            { TEXT_START_DEVICE, TOOLTIP_TEXT_DEVICE_START });
            doStopDeviceTest();

        }

    }

    /**
     * implementation of statusUpdateListener interface it is called when the
     * status of the device is updated
     * 
     * @param e
     *            the event generated by the device
     */
    public void statusUpdateOccurred(StatusUpdateEvent e)
    {
        int status = e.getStatus();

        String statusMsg = "StatusUpdateOccurred - ";
        switch (status)
        {
            case JposConst.JPOS_SUE_POWER_ONLINE:
                statusMsg += "JPOS_SUE_POWER_ONLINE";
                break;

            case JposConst.JPOS_SUE_POWER_OFF_OFFLINE:
            case JposConst.JPOS_SUE_POWER_OFFLINE:
                statusMsg += "JPOS_SUE_POWER_OFF_OFFLINE";
                break;

        }
        //display the status update received
        ui.displayText(statusMsg);

    }

    public void dataOccurred(DataEvent e)
    {
        try
        {
            StringBuffer sb = new StringBuffer("dataOccurred={\n");
            sb.append("          ScanDataType Property  = ");
            sb.append(getScanDataTypeString( scanner.getScanDataType()));
            sb.append("\n          ScanDataLabel Property = ");
            sb.append(new String(scanner.getScanDataLabel()));
            sb.append("}");
            ui.displayText(sb.toString());
            scanner.setDataEventEnabled(true);
            ui.displayText("setDataEventEnabled(true)");
        }
        catch (JposException je)
        {
            String errMsg;
            errMsg = "JposException(" + je.getErrorCode() + ","
                    + je.getErrorCodeExtended() + "," + je.getMessage() + ")";
            ui.displayText(errMsg);
        }
    }

    //-------------------------------------------------------------------------
    // UPOS Functionality
    //

    //-------------------------------------------------------------------------
    // Protected Methods
    //

    /**
     * open claim and enable the device, display some properties
     * and open the Scanner
     * */
    protected void doStartDeviceTest() throws JposException
    {

        scanner.open(ui.getLogicalName());
        ui.displayText("Open(\"" + ui.getLogicalName() + "\")");
        try
        {
            // Common Cap/Properties
            ui.displayText("DeviceControlVersion = "
                    + scanner.getDeviceControlVersion());
            ui.displayText("DeviceControlDescription = "
                    + scanner.getDeviceControlDescription());
            ui.displayText("DeviceServiceVersion = "
                    + scanner.getDeviceServiceVersion());
            ui.displayText("DeviceServiceDescription = "
                    + scanner.getDeviceServiceDescription());
            ui.displayText("CapCompareFirmwareVersion = "
                    + scanner.getCapCompareFirmwareVersion());
            String capPowerReportingName = "";
            switch (scanner.getCapPowerReporting())
            {
                case JposConst.JPOS_PR_NONE:
                    capPowerReportingName += "JPOS_PR_NONE = ";
                    break;
                case JposConst.JPOS_PR_STANDARD:
                    capPowerReportingName += "JPOS_PR_STANDARD = ";
                    break;
                case JposConst.JPOS_PR_ADVANCED:
                    capPowerReportingName += "JPOS_PR_ADVANCED = ";
                    break;
            }
            ui.displayText("CapPowerReporting = " + capPowerReportingName
                    + scanner.getCapPowerReporting());
            ui.displayText("CapStatisticsReporting = "
                    + scanner.getCapStatisticsReporting());
            ui.displayText("CapUpdateFirmware = "
                    + scanner.getCapUpdateFirmware());
            ui.displayText("CapUpdateStatistics = "
                    + scanner.getCapUpdateStatistics());
            scanner.addStatusUpdateListener(this);
            ui.displayText("addStatusUpdateListener(this)");
            scanner.addDataListener(this);
            ui.displayText("addDataListener(this)");
            scanner.claim(1000);
            ui.displayText("Claim(1000)");
            scanner.setDeviceEnabled(true);
            ui.displayText("setDeviceEnabled(true)");
            scanner.setDataEventEnabled(true);
            ui.displayText("setDataEventEnabled(true)");
            // Specific Cap/Properties
            scanner.setDecodeData(true);
            ui.displayText("setDecodeData(true)");
            ui.displayText("#\n# Pass a label in front of the Scanner\n#");
        }
        catch (JposException je)
        {
            doStopDeviceTest();
            throw je;
        }
    }

    /**
     * remove data listener
     * disable release and close the device
     * */
    protected void doStopDeviceTest() throws JposException
    {
        scanner.removeDataListener(this);
        ui.displayText("removeDataListener(this)");
        scanner.removeStatusUpdateListener(this);
        ui.displayText("removeStatusUpdateListener(this)");
        scanner.close();
        ui.displayText("close()");
    }

    protected String getScanDataTypeString(int type){
        String typeString = null;
        switch(type)
        {
          case ScannerConst.SCAN_SDT_CCA:
               typeString ="SCAN_SDT_CCA";
               break;

          case ScannerConst.SCAN_SDT_CCB:
              typeString ="SCAN_SDT_CCB";
              break;

          case ScannerConst.SCAN_SDT_CCC:
              typeString ="SCAN_SDT_CCC";
              break;

          case ScannerConst.SCAN_SDT_Codabar:
              typeString ="SCAN_SDT_Codabar";
              break;

          case ScannerConst.SCAN_SDT_Code128:
              typeString ="SCAN_SDT_Code128";
              break;

          case ScannerConst.SCAN_SDT_Code39:
              typeString ="SCAN_SDT_Code39";
              break;

          case ScannerConst.SCAN_SDT_EAN128:
              typeString ="SCAN_SDT_EAN128";
              break;

          case ScannerConst.SCAN_SDT_EAN13:
              typeString ="SCAN_SDT_EAN13";
              break;

          case ScannerConst.SCAN_SDT_EAN13_S:
              typeString ="SCAN_SDT_EAN13_S";
              break;

          case ScannerConst.SCAN_SDT_EAN8:
              typeString ="SCAN_SDT_EAN8";
              break;

          case ScannerConst.SCAN_SDT_EAN8_S:
              typeString ="SCAN_SDT_EAN8_S";
              break;

          case ScannerConst.SCAN_SDT_ITF:
              typeString ="SCAN_SDT_ITF";
              break;

          case ScannerConst.SCAN_SDT_MAXICODE:
              typeString ="SCAN_SDT_MAXICODE";
              break;

          case ScannerConst.SCAN_SDT_OCRA:
              typeString ="SCAN_SDT_OCRA";
              break;

          case ScannerConst.SCAN_SDT_OCRB:
              typeString ="SCAN_SDT_OCRB";
              break;

          case ScannerConst.SCAN_SDT_OTHER:
              typeString ="SCAN_SDT_OTHER";
              break;

          case ScannerConst.SCAN_SDT_PDF417:
              typeString ="SCAN_SDT_PDF417";
              break;

          case ScannerConst.SCAN_SDT_RSS14:
              typeString ="SCAN_SDT_RSS14";
              break;

          case ScannerConst.SCAN_SDT_RSS_EXPANDED:
              typeString ="SCAN_SDT_RSS_EXPANDED";
              break;

          case ScannerConst.SCAN_SDT_TF:
              typeString ="SCAN_SDT_TF";
              break;

          case ScannerConst.SCAN_SDT_UNKNOWN:
              typeString ="SCAN_SDT_UNKNOWN";
              break;

          case ScannerConst.SCAN_SDT_UPCA:
              typeString ="SCAN_SDT_UPCA";
              break;

          case ScannerConst.SCAN_SDT_UPCA_S:
              typeString ="SCAN_SDT_UPCA_S";
              break;

          case ScannerConst.SCAN_SDT_UPCD1:
              typeString ="SCAN_SDT_UPCD1";
              break;

          case ScannerConst.SCAN_SDT_UPCD2:
              typeString ="SCAN_SDT_UPCD2";
              break;

          case ScannerConst.SCAN_SDT_UPCD3:
              typeString ="SCAN_SDT_UPCD3";
              break;

          case ScannerConst.SCAN_SDT_UPCD4:
              typeString ="SCAN_SDT_UPCD4";
              break;

          case ScannerConst.SCAN_SDT_UPCD5:
              typeString ="SCAN_SDT_UPCD5";
              break;

          case ScannerConst.SCAN_SDT_UPCE:
              typeString ="SCAN_SDT_UPCE";
              break;

          case ScannerConst.SCAN_SDT_UPCE_S:
              typeString ="SCAN_SDT_UPCE_S";
              break;
              
           default:typeString = Integer.toString(type);
           break;
        }
        return typeString;
    }
    //-------------------------------------------------------------------------
    // instance variables
    //
    private Scanner scanner = new Scanner();

    private static DemoUI ui;

    //-------------------------------------------------------------------------
    // constants
    //
    /** Label for Start Button */
    private static final String TEXT_START_DEVICE = "Start Scanner Test";

    /** Label for Stop Button */
    private static final String TEXT_STOP_DEVICE = "Stop Scanner Test";

    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_DEVICE_START = "Open, claim and"
            + " enable the Scanner and make the device ready to receive data";

    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_DEVICE_STOP = "Unregister " +
                 "the listener and closes the Scanner";
}
